/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class VWLogParamPanel
extends JPanel
implements IVWExpressionTextFieldListener {
    private GridBagConstraints m_gbCons = null;
    protected VWToolbarBorder m_eventTypeBorder = null;
    protected VWExpressionTextField m_eventTypeTextField = null;
    protected VWToolbarBorder m_eventMessageBorder = null;
    protected VWExpressionTextField m_eventMessageTextField = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initLogControls();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        this.m_instructionDef = instructionDef;
        this.m_eventTypeTextField.removeExpressionTextFieldListener(this);
        this.m_eventMessageTextField.removeExpressionTextFieldListener(this);
        String type = VWInstruction.LogInstructionGetEventType(this.m_instructionDef);
        String msg = VWInstruction.LogInstructionGetEventMessage(this.m_instructionDef);
        this.m_eventTypeTextField.setText(type);
        this.m_eventMessageTextField.setText(msg);
        this.m_eventTypeTextField.addExpressionTextFieldListener(this);
        this.m_eventMessageTextField.addExpressionTextFieldListener(this);
    }

    private void initLogControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_eventTypeBorder = new VWToolbarBorder(VWResource.s_eventTypeExpression);
        this.add((Component)this.m_eventTypeBorder, this.m_gbCons);
        JPanel clientPanel = this.m_eventTypeBorder.getClientPanel();
        clientPanel.setLayout(new GridLayout());
        this.m_eventTypeTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_eventTypeTextField.addExpressionTextFieldListener(this);
        clientPanel.add(this.m_eventTypeTextField);
        this.m_eventMessageBorder = new VWToolbarBorder(VWResource.s_eventMessageExpression);
        ++this.m_gbCons.gridy;
        this.m_gbCons.weighty = 1.0;
        this.add((Component)this.m_eventMessageBorder, this.m_gbCons);
        JPanel messagePanel = this.m_eventMessageBorder.getClientPanel();
        messagePanel.setLayout(new GridLayout());
        this.m_eventMessageTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_eventMessageTextField.addExpressionTextFieldListener(this);
        messagePanel.add(this.m_eventMessageTextField);
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_eventMessageTextField) {
            this.updateEventMessage();
        } else if (src == this.m_eventTypeTextField) {
            this.updateEventType();
        }
    }

    private void updateEventType() {
        try {
            String type = this.m_eventTypeTextField.getText();
            VWInstruction.LogInstructionSetEventType(this.m_instructionDef, type);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateEventMessage() {
        try {
            String msg = this.m_eventMessageTextField.getText();
            VWInstruction.LogInstructionSetEventMessage(this.m_instructionDef, msg);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

